% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erafyCohort.R
\name{erafyCohort}
\alias{erafyCohort}
\title{Erafy a cohort_table collapsing records separated gapEra days or less.}
\usage{
erafyCohort(
  cohort,
  gapEra,
  cohortId = NULL,
  nameStyle = "{cohort_name}_{gap_era}",
  name = omopgenerics::tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort_table object.}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era.}

\item{cohortId}{A cohort definition id to restrict by. If NULL, all cohorts
will be included.}

\item{nameStyle}{String to create the new names of cohorts. Must contain
'\{cohort_name\}' if more than one cohort is present and '\{gap_era\}' if more
than one gapEra is provided.}

\item{name}{Name of the new cohort table, it must be a length 1 character
vector.}
}
\value{
A cohort_table object.
}
\description{
Erafy a cohort_table collapsing records separated gapEra days or less.
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

cdm$cohort2 <- cdm$cohort1 |>
  erafyCohort(gapEra = 30, name = "cohort2")

cdm$cohort2

settings(cdm$cohort2)

mockDisconnect(cdm)
}
}
