% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessSC.R
\name{preprocessSC}
\alias{preprocessSC}
\title{A function for preprocessing gene expression matrix.}
\usage{
preprocessSC(X, min.expressed.gene = 0, min.expressed.cell = 2,
  max.expressed.ratio = 1, normalize.by.size.effect = FALSE)
}
\arguments{
\item{X}{Gene expression matrix (Gene by Cell).}

\item{min.expressed.gene}{Cell level filtering criteria. For a given cell, if the number of expressed genes are less than min.expressed.gene, we filter it out.}

\item{min.expressed.cell}{Gene level filtering criteria. For a given gene, if the number of expressed cells are less than min.expressed.cell, we filter it out.}

\item{max.expressed.ratio}{Gene level filtering criteria. For a given gene, if the ratio of expressed cells are larger than max.expressed.ratio, we filter it out.}

\item{normalize.by.size.effect}{Normaize using size factor.}
}
\value{
Filtered gene expression matrix
}
\description{
Preprocess gene expression data
}
\examples{

data(exdata)
exdata <- preprocessSC(exdata)

}
\references{
Il-Youp Kwak, Wuming Gong, Kaoko Koyano-Nakagawa and Daniel J. Garry (2017+)
DrImpute: Imputing dropout eveents in single cell RNA sequencing data
}
\seealso{
\code{\link{DrImpute}}
}
\author{
Wuming Gong
}
