% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tVaRPlot2DCL.R
\name{tVaRPlot2DCL}
\alias{tVaRPlot2DCL}
\title{Plots t VaR against confidence level}
\usage{
tVaRPlot2DCL(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 4
 or 5. In case there 4 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily P/L data data

 mu Mean of daily P/L data data

 sigma Standard deviation of daily P/L data data

 df Number of degrees of freedom in the t distribution

 cl VaR confidence level and must be a vector

 hp VaR holding period and must be a scalar}
}
\description{
Plots the VaR of a portfolio against confidence level assuming that P/L data
is t distributed, for specified confidence level and holding period.
}
\examples{
# Plots VaR against confidene level given P/L data data
   data <- runif(5, min = 0, max = .2)
   tVaRPlot2DCL(returns = data, df = 6, cl = seq(.85,.99,.01), hp = 60)

   # Computes VaR against confidence level given mean and standard deviation of P/L data
   tVaRPlot2DCL(mu = .012, sigma = .03, df = 6, cl = seq(.85,.99,.01), hp = 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

