% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LogNormalVaRDFPerc.R
\name{LogNormalVaRDFPerc}
\alias{LogNormalVaRDFPerc}
\title{Percentiles of VaR distribution function for normally distributed geometric returns}
\usage{
LogNormalVaRDFPerc(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
standard deviation data. Accordingly, number of input arguments is either 5
or 7. In case there 5 input arguments, the mean, standard deviation and number
of observations of data are computed from returns data. See examples for details.

returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 n Sample size

 investment Size of investment

 perc Desired percentile

 cl VaR confidence level and must be a scalar

 hp VaR holding period and must be a a scalar

 Percentiles of VaR distribution function and is scalar}
}
\description{
Estimates the percentile of VaR distribution function for normally distributed
geometric returns, using the theory of order statistics.
}
\examples{
# Estimates Percentiles of VaR distribution
   data <- runif(5, min = 0, max = .2)
   LogNormalVaRDFPerc(returns = data, investment = 5, perc = .7, cl = .95, hp = 60)

   # Computes v given mean and standard deviation of return data
   LogNormalVaRDFPerc(mu = .012, sigma = .03, n= 10, investment = 5, perc = .8, cl = .99, hp = 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

