% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AmericanPutESSim.R
\name{AmericanPutESSim}
\alias{AmericanPutESSim}
\title{Estimates ES of American vanilla put using binomial option valuation tree and Monte Carlo
Simulation}
\usage{
AmericanPutESSim(amountInvested, stockPrice, strike, r, mu, sigma, maturity,
  numberTrials, numberSteps, cl, hp)
}
\arguments{
\item{amountInvested}{Total amount paid for the Put Option and is positive
(negative) if the option position is long (short)}

\item{stockPrice}{Stock price of underlying stock}

\item{strike}{Strike price of the option}

\item{r}{Risk-free rate}

\item{mu}{Expected rate of return on the underlying asset and is in
annualised term}

\item{sigma}{Volatility of the underlying stock and is in annualised
term}

\item{maturity}{The term to maturity of the option in days}

\item{numberTrials}{The number of interations in the Monte Carlo simulation
exercise}

\item{numberSteps}{The number of steps over the holding period at each
of which early exercise is checked and is at least 2}

\item{cl}{Confidence level for which VaR is computed and is scalar}

\item{hp}{Holding period of the option in days and is scalar}
}
\value{
Monte Carlo Simulation VaR estimate and the bounds of the 95%
confidence interval for the VaR, based on an order-statistics analysis
of the P/L distribution
}
\description{
Estimates ES of American Put Option using binomial tree to price the option
valuation tree and Monte Carlo simulation with a binomial option valuation
tree nested within the MCS. Historical method to compute the VaR.
}
\examples{
# Market Risk of American Put with given parameters.
   AmericanPutESSim(0.20, 27.2, 25, .16, .2, .05, 60, 30, 20, .95, 30)
}
\author{
Dinesh Acharya
}
\references{
Dowd, Kevin. Measuring Market Risk, Wiley, 2007.

Lyuu, Yuh-Dauh. Financial Engineering & Computation: Principles,
Mathematics, Algorithms, Cambridge University Press, 2002.
}

