% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AdjustedVarianceCovarianceES.R
\name{AdjustedVarianceCovarianceES}
\alias{AdjustedVarianceCovarianceES}
\title{Cornish-Fisher adjusted Variance-Covariance ES}
\usage{
AdjustedVarianceCovarianceES(vc.matrix, mu, skew, kurtosis, positions, cl, hp)
}
\arguments{
\item{vc.matrix}{Variance covariance matrix for returns}

\item{mu}{Vector of expected position returns}

\item{skew}{Return skew}

\item{kurtosis}{Return kurtosis}

\item{positions}{Vector of positions}

\item{cl}{Confidence level and is scalar}

\item{hp}{Holding period and is scalar}
}
\description{
Function estimates the Variance-Covariance ES of a multi-asset
portfolio using the Cornish - Fisher adjustment for portfolio return
non-normality, for specified confidence level and holding period.
}
\examples{
# Variance-covariance ES for randomly generated portfolio
   vc.matrix <- matrix(rnorm(16), 4, 4)
   mu <- rnorm(4)
   skew <- .5
   kurtosis <- 1.2
   positions <- c(5, 2, 6, 10)
   cl <- .95
   hp <- 280
   AdjustedVarianceCovarianceES(vc.matrix, mu, skew, kurtosis, positions, cl, hp)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

