#' Hill Plot
#'
#' Displays a plot of the Hill Estimator against tail sample size.
#'
#' @param Ra The data set
#' @param maximum.tail.size maximum tail size and should be greater than a
#' quarter of the sample size.
#' 
#' @references Dowd, K. Measuring Market Risk, Wiley, 2007.
#' 
#' 
#' @author Dinesh Acharya
#' @examples
#' 
#'    # Hill Estimator - Tail Sample Size Plot for random normal dataset
#'    Ra <- rnorm(1000)
#'    HillPlot(Ra, 180)
#'
#' @export
HillPlot <- function(Ra, maximum.tail.size){
  
  data <- as.vector(Ra)
  data <- sort(data)
  n <- length(data)
  i <- which(data <= 0)
  i <- max(i)
  max.k <- min(maximum.tail.size, n - i)
  he <- double(max.k)
  # Derivation of Hill Estimators and tail size series
  for (k in 2:max.k){
    he[k] <- HillEstimator(data,k)
  }
  # Plot of Hill Estimator against tail size
  j <- which(he != 0)
  he <- he[j]
  k <- 2:max.k
  plot(k, he, type = "l", col="red", main = "Hill Estimator against Tail Size", 
       xlab="Number of observations in tail (k)", ylab = "Hill estimator")
  
}                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       