\name{create_interactive_plots}
\alias{create_interactive_plots}

\title{
Create Interactive Plots
}
\description{
This function creates interactive plots using plotly for better user experience.
}
\usage{
create_interactive_plots(data, plot_type = "scatter")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
A data.frame with sentiment analysis results
}
  \item{plot_type}{
Type of interactive plot: "scatter", "bar", "timeline"
}  
}

\value{
Plotly object.
}

\author{
Hossein Hassani and Leila Marvian Mashhad and Nadejda Komendantova.
}

\examples{
sample_data <- data.frame(
  City              = c("CityA", "CityB", "CityA", "CityC", "CityB"),
  Longitude         = c(10.0, 11.5, 10.0, 12.2, 11.5),
  Latitude          = c(50.1, 49.9, 50.1, 50.5, 49.9),
  sentiment_score   = c( 2.5, -1.0,  0.0,  3.0, -2.0),
  sentiment_category= c("Positive","Negative","Neutral","Positive","Negative"),
  User_Comment      = c(
    "Amazing rescue efforts!",
    "Terrible flooding last night.",
    "All calm here.",
    "Hope everyone is safe.",
    "Worst disaster ever."
  ),
  Timestamp         = as.POSIXct(c(
    "2025-07-10 14:00", "2025-07-10 15:30",
    "2025-07-11 10:00", "2025-07-11 12:45",
    "2025-07-12 09:20"
  ))
)


scatter_plot <- create_interactive_plots(sample_data, plot_type = "scatter")


bar_plot <- create_interactive_plots(sample_data, plot_type = "bar")
bar_plot

timeline_plot <- create_interactive_plots(sample_data, plot_type = "timeline")
timeline_plot
}
