analyze_disaster_sentiment <- function(data, text_column = "User_Comment", method = "afinn") {
  
  if (!requireNamespace("tidytext", quietly = TRUE)) {
    stop("Package tidytext is required but not installed.")
  }
  
  # Simple AFINN-based sentiment analysis
  afinn_words <- list(
    "good" = 3, "great" = 3, "excellent" = 4, "amazing" = 4, "wonderful" = 4,
    "bad" = -3, "terrible" = -3, "awful" = -3, "horrible" = -4, "disaster" = -2,
    "help" = 2, "safe" = 2, "rescue" = 2, "support" = 2, "hope" = 2,
    "damage" = -2, "destroy" = -3, "fear" = -2, "scary" = -2, "worried" = -2,
    "emergency" = -1, "crisis" = -2, "flood" = -1, "fire" = -1, "earthquake" = -2,
    "love" = 3, "beautiful" = 3, "enjoying" = 2, "happy" = 3, "perfect" = 3,
    "hate" = -3, "down" = -1, "hating" = -3, "feeling" = 0
  )
  
  # Function to calculate sentiment score
  calculate_sentiment <- function(text) {
    if (is.na(text) || text == "") return(0)
    
    words <- tolower(unlist(strsplit(as.character(text), "\\W+")))
    scores <- sapply(words, function(word) {
      if (word %in% names(afinn_words)) {
        return(afinn_words[[word]])
      } else {
        return(0)
      }
    })
    
    return(mean(scores))
  }
  
  # Apply sentiment analysis
  data$sentiment_score <- sapply(data[[text_column]], calculate_sentiment)
  
  # Categorize sentiment
  data$sentiment_category <- ifelse(data$sentiment_score > 0.5, "Positive",
                                   ifelse(data$sentiment_score < -0.5, "Negative", "Neutral"))
  
  return(data)
}