% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalue_calculation.R
\name{pval}
\alias{pval}
\title{Calculation of p-values for each score with respect to the null.}
\usage{
pval(actual.scores, null.scores, method = "exponential")
}
\arguments{
\item{actual.scores}{a vector including actual scores with the length of number of nodes (N_nodes).}

\item{null.scores}{a matrix of null scores with the dimension of N_nodes x N_repeat}

\item{method}{statistical test method: c(\code{"exponential"}, \code{"gamma"}, \code{"non_parametric"})}
}
\value{
vector of p-values
}
\description{
Calculation of p-values for each score with respect to the null.
}
\details{
Calculate the p-value for each node based on the actual and null diffusion scores.
}
\examples{
graph = graph_generation(n.nodes = 10, prob.connection = 0.5)
initial_score = c(rep(0,5),0.2, 0.3, 0, 0, 0.5)
names(initial_score) = igraph::V(graph)
Actual_score = actual_score(graph = graph, initial.score = initial_score, damping = 0.7)
Null_score = null_score(graph = graph, initial.score = initial_score, damping = 0.7, N.repeat = 10)
pvalue = pval(actual.scores = Actual_score, null.scores = Null_score, method = "exponential")
}
