% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{optim.stop}
\alias{optim.stop}
\title{Title optim wrapper for early stopping criterion}
\usage{
optim.stop(
  par,
  fn,
  gr = NULL,
  fn.stop = NA,
  fn.NaN = NaN,
  control = list(),
  ...
)
}
\arguments{
\item{par}{starting point for optim}

\item{fn}{objective function, like in optim().}

\item{gr}{gradient function, like in optim().}

\item{fn.stop}{early stopping criterion}

\item{fn.NaN}{replacement value of fn when returns NaN}

\item{control}{control parameters for optim()}

\item{...}{additional arguments passed to optim()}
}
\value{
list with best solution and all solutions
}
\description{
Title optim wrapper for early stopping criterion
}
\examples{
fn = function(x) x^6
o = optim( par=15, fn,lower=-20,upper=20,method='L-BFGS-B')
o.s = optim.stop( par=15, fn,lower=-20,upper=20,method='L-BFGS-B',fn.stop=0.1)
#check o.s$value == 0.1 && o.s$counts < o$counts
}
\author{
Yann Richet, IRSN
}
