% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DF_CV.R
\name{DF_CV}
\alias{DF_CV}
\title{Decision Forest algorithm: Model training with Cross-validation}
\usage{
DF_CV(X, Y, stop_step = 10, CV_fold = 5, Max_tree = 20, min_split = 10,
  cp = 0.1, Filter = F, p_val = 0.05, Method = "bACC", Quiet = T,
  Grace_val = 0.05, imp_accu_val = 0.01, imp_accu_criteria = F)
}
\arguments{
\item{X}{Training Dataset}

\item{Y}{Training data endpoint}

\item{stop_step}{How many extra step would be processed when performance not improved, 1 means one extra step}

\item{CV_fold}{Fold of cross-validation (Default = 5)}

\item{Max_tree}{Maximum tree number in Forest}

\item{min_split}{minimum leaves in tree nodes}

\item{cp}{parameters to pruning decision tree, default is 0.1}

\item{Filter}{doing feature selection before training}

\item{p_val}{P-value threshold measured by t-test used in feature selection, default is 0.05}

\item{Method}{Which is used for evaluating training process. MIS: Misclassification rate; ACC: accuracy}

\item{Quiet}{if TRUE (default), don't show any message during the process}

\item{Grace_val}{Grace Value in evaluation: the next model should have a performance (Accuracy, bACC, MCC) not bad than previous model with threshold}

\item{imp_accu_val}{improvement in evaluation: adding new tree should improve the overall model performance (Accuracy, bACC, MCC) by threshold}

\item{imp_accu_criteria}{if TRUE, model must have improvement in accumulated accuracy}
}
\value{
.$performance:      Overall training accuracy (Cross-validation)

.$pred:          Detailed training prediction (Cross-validation)

.$detail:        Detailed usage of Decision tree Features/Models and their performances in all CVs

.$Method:        pass evaluating Methods used in training

.$cp:            pass cp value used in training decision trees
}
\description{
Decision Forest algorithm: Model training with Cross-validation
  Default is 5-fold cross-validation
}
\examples{
  ##data(iris)
  X = iris[,1:4]
  Y = iris[,5]
  names(Y)=rownames(X)

  random_seq=sample(nrow(X))
  split_rate=3
  split_sample = suppressWarnings(split(random_seq,1:split_rate))
  Train_X = X[-random_seq[split_sample[[1]]],]
  Train_Y = Y[-random_seq[split_sample[[1]]]]

  CV_result = DF_CV(Train_X, Train_Y)


}
