% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a.R
\name{a}
\alias{a}
\title{Life Annuities}
\usage{
a(x, h, n, k = 1, i = 0.04, data, prop = 1, assumption = "none", cap = 1)
}
\arguments{
\item{x}{An integer. The age of the insuree.}

\item{h}{An integer. The deferral period.}

\item{n}{An integer. Number of years of coverage.}

\item{k}{An integer. Number of payments per year.}

\item{i}{The interest rate. A numeric type value.}

\item{data}{A data.frame of the mortality table, with the first column being the age, and the second one the probability of death.}

\item{prop}{A numeric value. It represents the proportion of the mortality table being used (between 0 and 1).}

\item{assumption}{A character string. The assumption used for fractional ages ("UDD" for uniform distribution of deaths, "constant" for constant force of mortality and "none" if there is no fractional coverage).}

\item{cap}{A numeric type value. The annualized value of the payment.}
}
\value{
Returns a numeric value (actuarial present value).
}
\description{
Calculates the present value of a life annuity.
}
\examples{
a(20,0,15,1,0.04,CSO58FALB,1,"none",1200)
a(23,7,9,1,0.04,GAM71F,1,"none",5000)
a(33,3,10,4,0.04,CSO80MANB,1,"constant",3000)
a(20,5,10,4,0.04,CSO58MANB,1,"UDD",5000)

}
\references{
Chapter 2 of  Life Contingencies (1952) by Jordan, chapter 5 of  Actuarial Mathematics (1997) by Bowers, Gerber, Hickman, Jones & Nesbitt.
}
\keyword{Annuities}
\keyword{Life}
