% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Table_Gompertz.R
\name{Table_Gompertz}
\alias{Table_Gompertz}
\title{Gompertz's Law of Mortality Table Creator}
\usage{
Table_Gompertz(x0, omega, B, C)
}
\arguments{
\item{x0}{A numeric type value. The initial age of the table.}

\item{omega}{A numeric type value. The final age of the table.}

\item{B}{A numeric type value. A parameter of the law.}

\item{C}{A numeric type value. A parameter of the law.}
}
\value{
Returns a data.frame object containing age and death probabilities.
}
\description{
Creates a mortality table under Gompertz's law.
}
\examples{
Table_Gompertz(0,100,0.00008,1.07)

}
\references{
Chapter 3 (p 77-78) of  Actuarial Mathematics (1997) by Bowers, Gerber, Hickman, Jones & Nesbitt.
}
\keyword{Gompertz's}
\keyword{law}
\keyword{table.}
