% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Em.R
\name{Em}
\alias{Em}
\title{Group Pure Endowment}
\usage{
Em(
  x,
  n,
  i = 0.04,
  data,
  prop = 1,
  type = "joint",
  quant = 1,
  assumption = "none",
  cap = 1
)
}
\arguments{
\item{x}{A vector of integers. The age of the insurees.}

\item{n}{The term of the endowment. An integer, for annual coverage, or a numeric for fractional coverage.}

\item{i}{The interest rate. A numeric type value.}

\item{data}{A data.frame containing the mortality table, with the first column being the age and the second one, the probability of death.}

\item{prop}{A numeric value. It represents the proportion of the mortality table being used (between 0 and 1).}

\item{type}{A character string. Conditions to be met in order to access the benefit of the endowment ("joint", "exactly" or "atleast").}

\item{quant}{An integer. Required only if type is not "joint". If type is "exactly" it represents the exact amount of survivors required for the endowment to be payed. If type is "atleast", it represents the minimum number of survivors required.}

\item{assumption}{A character string. The assumption used for fractional ages ("UDD" for uniform distribution of deaths, "constant" for constant force of mortality and "none" if there is no fractional coverage).}

\item{cap}{A numeric type value. The payment.}
}
\description{
Calculates the Pure endowments for a group of insurees.
}
\examples{
ages<-c(23,33,33)
Em(ages,15,0.04,CSO80MANB,1,"joint")
Em(ages,20.5,0.04,CSO80MANB,1,"joint",assumption = "constant",cap= 1)
Em(ages,10.5,0.04,CSO80MANB,1,"joint",assumption = "UDD", cap=1)
ages<-c(20,23,24,25)
Em(ages,15,0.04,CSO80MANB,1,"exactly",1,"none",1)
Em(ages,24.2,0.04,CSO80MANB,1,"exactly",2,"constant",1)
Em(ages,8.2,0.04,CSO80MANB,1,"exactly",3,"UDD",1)

ages<-c(40,42,56,57,58,59)
Em(ages,15,0.04,CSO80MANB,1,"atleast",1,"none",1)
Em(ages,25.5,0.04,CSO80MANB,1,"atleast",4,"constant",1)
Em(ages,15.3,0.04,CSO80MANB,1,"atleast",3,"UDD",1)


}
\keyword{Endowment}
\keyword{Pure}
