% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rate_converter.R
\name{Rate_converter}
\alias{Rate_converter}
\title{Interest & Discount Rate Converter}
\usage{
Rate_converter(num, rate1, m, rate2, k, type = "days")
}
\arguments{
\item{num}{A numeric type value. It is the interest/discount rate to be converted.}

\item{rate1}{A string ("i", "d","f" or "j"). Type of interest/discount rate to be converted.}

\item{m}{number of capitalizations.}

\item{rate2}{A string ("i" for effective interest rate, "d" for effective discount rate,"f" for nominal discount rate, "j" for nominal interest rate).Type of interest/discount rate to obtain.}

\item{k}{An integer. Number of capitalizations per year.}

\item{type}{A string. Reference for "k", indicating whether it is expressed as a fraction or as days ("frac" or "days").}
}
\description{
Converts nominal and effective interest and discount rates.
}
\examples{
Rate_converter(0.04,"i",1,"i",6,"frac")
Rate_converter(0.04,"f",1,"j",6,"frac")
Rate_converter(0.04,"f",365,"d",60,"days")
Rate_converter(0.04,"f",365,"f",60,"days")

}
\keyword{Discount}
\keyword{Interest}
\keyword{Rate}
