% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Payment_Protection.R
\name{Payment_Protection}
\alias{Payment_Protection}
\title{Payment Protection}
\usage{
Payment_Protection(
  x,
  n,
  k = 1,
  V0,
  i = 0.04,
  ip = 0.04,
  data,
  prop = 1,
  type = "outstanding_debt",
  method = "interest_only"
)
}
\arguments{
\item{x}{An integer. The age of the insuree.}

\item{n}{An integer. Loan term (in years).}

\item{k}{An integer. Number of payments per year.}

\item{V0}{A numeric type value. Loan value.}

\item{i}{The interest rate. A numeric type value.}

\item{ip}{The interest rate of the loan. A numeric type value.}

\item{data}{A data.frame of the mortality table, with the first column being the age and the second one the probability of death.}

\item{prop}{A numeric value. It represents the proportion of the mortality table being used (between 0 and 1).}

\item{type}{A character string. The type of loan protection/reimburstment ("outstanding_debt" or "payments").}

\item{method}{A character string. Amortization scheme ("constant_instalment", "interest_only" or "constant_principal").}
}
\value{
Returns a numeric value (actuarial present value).
}
\description{
Calculates the present value of the loan insurance.
}
\examples{
Payment_Protection(35,2,1,1000000,0.04,0.06,CSO80MANB,1,"payments","constant_instalment")
Payment_Protection(43,2,1,1000000,0.04,0.07,CSO80MANB,1,"outstanding_debt","constant_instalment")
Payment_Protection(30,2,2,1000000,0.04,0.06,CSO80MANB,1,"payments","constant_instalment")
Payment_Protection(20,2,2,1000000,0.04,0.07,CSO80MANB,1,"outstanding_debt","constant_instalment")
Payment_Protection(33,2,1,1000000,0.04,0.05,CSO80MANB,1,"payments","interest_only")
Payment_Protection(56,2,1,1000000,0.04,0.06,CSO80MANB,1,"outstanding_debt","interest_only")
Payment_Protection(40,2,2,1000000,0.04,0.06,CSO80MANB,1,"payments","interest_only")
Payment_Protection(25,2,2,1000000,0.04,0.05,CSO80MANB,1,"outstanding_debt","interest_only")
Payment_Protection(23,2,1,1000000,0.04,0.07,CSO80MANB,1,"payments","constant_principal")
Payment_Protection(35,2,1,1000000,0.04,0.06,CSO80MANB,1,"outstanding_debt","constant_principal")
Payment_Protection(45,2,2,1000000,0.04,0.05,CSO80MANB,1,"payments","constant_principal")
Payment_Protection(35,2,2,1000000,0.04,0.07,CSO80MANB,1,"outstanding_debt","constant_principal")


}
\keyword{Payment}
\keyword{Protection}
