% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSUserDataObjectBase.R
\name{DSUserObjectResponse}
\alias{DSUserObjectResponse}
\title{DSUserObjectResponse}
\value{
DSUserObjectResponse object
}
\description{
This is the object returned from the client class' GetItem, CreateItem, UpdateItem
and DeleteItem requests.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{UserObjectId}}{The ID of the object requested. If the item is deleted, the UserObject
property will be NULL but the UserObjectId field will be populated}

\item{\code{UserObjectType}}{specifies the returned object type. e.g. DSUserObjectTypes.List,
DSUserObjectTypes.TimeSeries, etc.}

\item{\code{UserObject}}{For all queries bar DeletItem, if the query is successful, this property will
contain the user created item requested.}

\item{\code{ResponseStatus}}{This property will contain a DSUserObjectResponseStatus value.
DSUserObjectResponseStatus.UserObjectSuccess represents a successful response.}

\item{\code{ErrorMessage}}{If ResponseStatus is not DSUserObjectResponseStatus.UserObjectSuccess this
status string will provide a description of the error condition.}

\item{\code{Properties}}{Not currently used and will currently always return NULL.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DSUserObjectResponse-new}{\code{DSUserObjectResponse$new()}}
\item \href{#method-DSUserObjectResponse-clone}{\code{DSUserObjectResponse$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSUserObjectResponse-new"></a>}}
\if{latex}{\out{\hypertarget{method-DSUserObjectResponse-new}{}}}
\subsection{Method \code{new()}}{
Initialize
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSUserObjectResponse$new(jsonResp = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jsonResp}}{JSON Response}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
DSUserObjectResponse object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DSUserObjectResponse-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DSUserObjectResponse-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DSUserObjectResponse$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
