% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_columns.R
\name{update_columns}
\alias{update_columns}
\title{Update variable types or values}
\usage{
update_columns(data, ind, what)
}
\arguments{
\item{data}{input data}

\item{ind}{a vector of either names or column positions of the variables to be dropped.}

\item{what}{either a function or a non-empty character string naming the function to be called. See \link[base]{do.call}.}
}
\description{
Quickly update selected variables using column names or positions.
}
\details{
\bold{This function updates \link[data.table]{data.table} object directly.} Otherwise, output data will be returned matching input object class.
}
\examples{
str(update_columns(iris, 1L, as.factor))
str(update_columns(iris, c("Sepal.Width", "Petal.Length"), "as.integer"))

## Apply log transformation to all columns
summary(airquality)
summary(update_columns(airquality, names(airquality), log))

## Force set factor to numeric
df <- data.frame("a" = as.factor(sample.int(10L)))
str(df)
str(update_columns(df, "a", function(x) as.numeric(levels(x))[x]))
}
\keyword{drop_columns}
