% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.log2.R
\name{stat.log2}
\alias{stat.log2}
\title{stat.log2}
\usage{
stat.log2(data.m, group.v, pseudo.count)
}
\arguments{
\item{data.m}{Data}

\item{group.v}{Groupings}

\item{pseudo.count}{A pseudocount value}
}
\value{
A dataframe of the log2 applied results
}
\description{
One of the functions required for the  differential expression
analysis using MAST (DEAnalysisMast()) function.
}
\examples{
\donttest{

#dataSC
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataSC.RData"
#dest <- "data/dataSC.RData"
#load(download.file(url, tempfile(data/dataSC.RData))
#load("dataSC.RData")
#SOLUTION
load(system.file("extdata", "dataSC.RData", package = "DWLS"))

#dataBulk
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataBulk.RData"
#dest <- "data/dataBulk.RData"
#load(download.file(url, tempfile(dest)))
#load("data/dataBulk.RData")
load(system.file("extdata", "dataBulk.RData", package = "DWLS"))

#labels
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/labels.RData"
#dest <- "data/labels.RData"
#download.file(url, dest)
#load("data/labels.RData")
load(system.file("extdata", "labels.RData", package = "DWLS"))

#data('trueLabels', package = "DWLS")
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/trueLabels.RData"
#dest <- "data/trueLabels.RData"
#download.file(url, dest)
#load("data/trueLabels.RData")
load(system.file("extdata", "trueLabels.RData", package = "DWLS"))

pseudo.count = 0.1
data.used.log2 <- log2(dataSC+pseudo.count)
colnames(data.used.log2)<-make.unique(colnames(data.used.log2))
diff.cutoff=0.5
id = labels
for (i in unique(id)){
  cells.symbol.list2 = colnames(data.used.log2)[which(id==i)]
  cells.coord.list2 = match(cells.symbol.list2, colnames(data.used.log2))
  cells.symbol.list1 = colnames(data.used.log2)[which(id != i)]
  cells.coord.list1 = match(cells.symbol.list1, colnames(data.used.log2))
  data.used.log2.ordered = cbind(data.used.log2[,cells.coord.list1],
                                        data.used.log2[,cells.coord.list2])}
group.v <- c(rep(0,length(cells.coord.list1)),
                                         rep(1, length(cells.coord.list2)))
}
}
