% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEAnalysisSeurat.R
\name{DEAnalysisSeurat}
\alias{DEAnalysisSeurat}
\title{Differential Expression without Idents (Seurat)}
\usage{
DEAnalysisSeurat(scdata, id, path)
}
\arguments{
\item{scdata}{The gene expression datafarme}

\item{id}{The unique identities within the data}

\item{path}{The path for the RData results}
}
\value{
An RData and rds file with the differential expression analysis
results for each unique id.
}
\description{
This function calculates the differential expression values
along with identifying the Idents (through Seurat). The output is
saved in an RData file for each unique identity (id).
}
\examples{
\donttest{

#dataSC
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataSC.RData"
#dest <- "data/dataSC.RData"
#download.file(url, dest)
#load("data/dataSC.RData")
load(system.file("extdata", "dataSC.RData", package = "DWLS"))

#dataBulk
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataBulk.RData"
#dest <- "data/dataBulk.RData"
#download.file(url, dest)
#load("data/dataBulk.RData")
load(system.file("extdata", "dataBulk.RData", package = "DWLS"))

#labels
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/labels.RData"
#dest <- "data/labels.RData"
#download.file(url, dest)
#load("data/labels.RData")
load(system.file("extdata", "labels.RData", package = "DWLS"))

#data('trueLabels', package = "DWLS")
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/trueLabels.RData"
#dest <- "data/trueLabels.RData"
#download.file(url, dest)
#load("data/trueLabels.RData")
load(system.file("extdata", "trueLabels.RData", package = "DWLS"))

labels<-trueLabels

#Old Method
#load("data/dataBulk.RData") #read in bulk data for WT1 (control condition #1)
#load("data/labels.RData") #read in single-cell labels from clustering
#data('dataSC_3', package = "DWLS")
#dataSC <- dataSC_3

labels<-trueLabels
#Change to real labels
newcat<-c("NonCycISC","CycISC","TA","Ent","PreEnt","Goblet","Paneth","Tuft","EE")
for (i in 1:length(newcat)){
  labels[which(labels==(i-1))]<-newcat[i]
  }
#Run deconvolution -- run on local
#Results in inst/extdata/results
Seurat_DE <- DEAnalysisSeurat(dataSC, labels, "inst/extdata/results")
}

}
