% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTWrapper2.R
\name{remove.erroneous.characters}
\alias{remove.erroneous.characters}
\title{remove.erroneous.characters}
\usage{
remove.erroneous.characters(
  x,
  threshold.for.numeric = 0.8,
  variable.should.be = "numeric",
  value.for.missing = NULL,
  ...
)
}
\arguments{
\item{x}{A character vector of values that should be a numeric vector but was coerced to a character due to a small number of entries.}

\item{threshold.for.numeric}{A value between 0 and 1 specifying the maximum proportion of x that does not "look" numeric. If threshold.for.numeric = 0.1, then no more than 10 percentage of the values in x can be values that do not "look" numeric.}

\item{variable.should.be}{A character string specifying the target variable type ("numeric" or "complex"). Defaults to "numeric".}

\item{value.for.missing}{The value to replace missing or erroneous entries with. Defaults to NA_real_ for numeric and NA_complex_ for complex.}

\item{...}{Additional arguments .}
}
\value{
A numeric or complex vector with erroneous entries replaced, or the original character vector if the proportion of erroneous values exceeds the threshold.
}
\description{
This function attempts to convert a character vector to a numeric or complex vector, replacing erroneous values based on a specified threshold.
}
