% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTWrapper2.R
\name{character.coercion.culprits}
\alias{character.coercion.culprits}
\title{character.coercion.culprits
This function identifies which character values in a vector are preventing it from being converted to a numeric vector.}
\usage{
character.coercion.culprits(x, threshold.for.numeric = 0.5, ...)
}
\arguments{
\item{x}{A character vector of values that should be a numeric vector but was coerced to a character due to a small number of non-numeric entries.}

\item{threshold.for.numeric}{A value between 0 and 1 specifying the maximum proportion of x that does not "look" numeric. If threshold.for.numeric = 0.1, then no more than 10 percentage of the values in x can be values that do not "look" numeric.}

\item{...}{Additional arguments.}
}
\value{
A character vector of values that are preventing x from being converted to numeric. Returns NA if the proportion of non-numeric values exceeds the threshold.
}
\description{
character.coercion.culprits
This function identifies which character values in a vector are preventing it from being converted to a numeric vector.
}
