% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separation.R
\name{separation}
\alias{separation}
\title{A measure of network separation}
\usage{
separation(graph, set_a, set_b)
}
\arguments{
\item{graph}{The input graph object. It should be either an igraph object or
an edge list matrix/data frame.}

\item{set_a}{The first gene set}

\item{set_b}{The second gene set}
}
\value{
The separation and distance measurement of the specified two modules.
}
\description{
Calculates the separation of two sets of nodes on a network. The
metric is calculated as in Menche et al. (2015).
}
\examples{
library(DTSEA)

# Load the data
data("random_graph", package = "DTSEA")

# Compute the separation metric
separation <- separation(
  graph = random_graph,
  set_a = c("4", "6", "8", "13"),
  set_b = c("8", "9", "10", "15", "18")
)
cat(separation, "\n")

}
