% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{sample.eta}
\alias{sample.eta}
\title{Function to sample from the posterior of the smoothing parameter eta conditioned on the data y.}
\usage{
sample.eta(N, ND, EV, Q, UL = 1000, log_prior)
}
\arguments{
\item{N}{the number of samples desired.}

\item{ND}{the rank of the precision matrix, the default value is n-3 for spatial data.}

\item{EV}{eigenvalues of the precision matrix spatial prior from the function make.M().}

\item{Q}{the data vector from the cross-product of observed data, Y, and eigenvalues from the M matrix, V.}

\item{UL}{the upper limit for the smoothing parameter value; used for the
ratio-of-uniform sampler, default is 1000.}

\item{log_prior}{a function of x evaluating the log of the prior density for eta}
}
\value{
N samples drawn from the posterior of eta given the data y \eqn{\pi(eta | y)}.
}
\description{
This function samples from the log-posterior density of the smoothing parameter from the
  thin-plate splines based spatial prior using a ratio-of-uniform sampler.
}
\examples{
## Use the Meuse River dataset from the package 'gstat'

library(sp)
library(gstat)
data(meuse.all)
coordinates(meuse.all) <- ~ x + y
X <- scale(coordinates(meuse.all))
tmp <- make.M(X)

EV <- tmp$M.eigen$values
V <- tmp$M.eigen$vectors

M <- tmp$M

Y <- scale(log(meuse.all$zinc))
Q <- crossprod(Y, V)

ND <- nrow(X) - 3
f <- function(x) -x ## log-prior for exponential distribution for the smoothing parameter

## Draw 100 samples from the posterior of eta given the data y.
sample.eta(100, ND, EV, Q, UL = 1000, f)
}
