% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/starSampler.R
\name{starSampler}
\alias{starSampler}
\title{A function implementing the star-sampler for the DRPT.}
\usage{
starSampler(X, Y, r, H = 99, S = 50)
}
\arguments{
\item{X}{A numeric vector containing the first sample.}

\item{Y}{A numeric vector containing the second sample.}

\item{r}{A function specifying the hypothesised density ratio.}

\item{H}{An integer specifying the number of permutations to use. Defaults to 99.}

\item{S}{An integer specifying the number of steps for the Markov-Chain defined in Algorithm
2 in \insertCite{BB2025DRPT;textual}{DRPT}. Defaults to 50.}
}
\value{
A list of \eqn{H+1} rearrangements of the whole sample. The first element of
the list is the original dataset. The other \eqn{H} elements are permutations of the original
dataset, where permutations are generated using Algorithm 2 in the paper.
}
\description{
A function implementing Algorithm 2 in \insertCite{BB2025DRPT;textual}{DRPT}.
}
\examples{
n = 250; m = n
r = function(x,y) {
  return(4*x*y)
   }

X = as.matrix(cbind(runif(n, 0, 1), runif(n, 0, 1)))
Y = as.matrix(cbind(rbeta(m, 0.5, 0.3), rbeta(m, 0.5, 0.4)))

starSampler(X, Y, r, H = 3, S = 20)
}
\references{
\insertRef{BB2025DRPT}{DRPT}
}
