% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale_color_doypa}
\alias{scale_color_doypa}
\title{Color scale for ggplot2 with DOYPAColors color palettes}
\usage{
scale_color_doypa(
  palette = NULL,
  n = NULL,
  reverse = FALSE,
  gradient = FALSE,
  discrete = FALSE,
  type = "all",
  colorblind = FALSE,
  ...
)
}
\arguments{
\item{palette}{A character string specifying the name of the palette to use. If `NULL`, a random palette will be selected.}

\item{n}{Number of colors needed. If `NULL`, it will default to the number of levels for discrete scales or to a continuous gradient for continuous scales.}

\item{reverse}{A logical value indicating whether to reverse the order of colors in the palette. Default is `FALSE`.}

\item{gradient}{A logical value indicating whether to interpolate colors as a  gradient of `n` colors between the first and last colors of the palette. If `FALSE`, returns the first `n` colors of the palette.}

\item{discrete}{Boolean indicating whether to generate a discrete or continuous palette (default: continuous).}

\item{type}{A character string specifying the type of palettes to select from: "all", "seq" (sequential), "div" (diverging), or "qual" (qualitative). Default is "all".}

\item{colorblind}{A logical value indicating whether to restrict the palette to colorblind-friendly options. Default is `FALSE`.}

\item{...}{Additional parameters passed to ggplot2's `scale_color_*` functions.}
}
\value{
A `ggplot2` color scale suitable for adding to a `ggplot2` object to control color aesthetics.
}
\description{
This function sets the color scale for ggplot2 using DOYPAColors color palettes, allowing you to 
apply these palettes to both discrete and continuous data.
}
\examples{
library(ggplot2)

# Discrete data
data(iris)
disc <- ggplot(iris, aes(x = Petal.Width, y = Petal.Length, color = Species)) +
  geom_point() + theme_classic()
disc <- disc + scale_color_doypa(palette = "buzz", discrete = TRUE)
print(disc)

# Continuous data
cont <- ggplot(iris, aes(x = Petal.Width, y = Petal.Length, color = Sepal.Length)) +
  geom_point() + theme_classic()
cont <- cont + scale_color_doypa(palette = "buzz")
print(cont)

# Colorblind-friendly palette
disc_colorblind <- ggplot(iris, aes(x = Petal.Width, y = Petal.Length, color = Species)) +
  geom_point() + theme_classic()
disc_colorblind <- disc_colorblind + scale_color_doypa(colorblind = TRUE, discrete = TRUE)
print(disc_colorblind)

}
