% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmvc.R
\name{dmvc}
\alias{dmvc}
\title{Perform DMC, DVC, DMVC,  and DMVC+ tests for genome-wide CpGs in 
methylation arrays.}
\usage{
dmvc(beta = beta, covariate = covariate, npermut=100,permut.seed=100,
corenumber=1)
}
\arguments{
\item{beta}{Methylation beta value matrix, row for CpGs, column for samples.
The matrix has sample name as the column names, and CpG names as the row 
names.}

\item{covariate}{covariate matrix, a data frame including all covariates in 
the regression model, whose row represents for samples, column represents 
different covariates. The matrix has sample names as the row names. The matrix 
must include a "group" column, which is a binary indicator (0 for normal and 
1 for tumor) to define two groups of samples to be compared.}

\item{npermut}{The number of permutations for computing the correlation that 
is needed for the joint tests}

\item{permut.seed}{The random seed used by permutation for joint tests}

\item{corenumber}{The number of cores to be used for joint tests; if 
corenumber>1, a parallel computing version will be used to speed up the 
computation}
}
\value{
A data frame with the following columns.
\item{Mean_normal}{
Mean of beta values for normal samples.
}
\item{Mean_tumor}{
Mean of beta values for tumor samples.
}
\item{Mean_all}{
Mean of beta values for all samples.
}
\item{SD_normal}{
Standard deviation of beta values for normal samples.
}
\item{SD_tumor}{
Standard deviation of beta values for tumor samples.
}
\item{SD_all}{
Standard deviation of beta values for all samples.
}
\item{DMCP}{
p-value from DMC test.
}
\item{DVCP}{
p-value from DVC test.
}
\item{Joint1P}{
Joint test for DMVC+ (test for hypermethylation and increased
variance in cancer samples).
}
\item{Joint2P}{
Joint test for DMVC (test for differential methylation in both
direction and increased variance in cancer samples).
}
\item{LRT1}{
Likelihood ratio test statistics for joint test1.
}
\item{LRT2}{
Likelihood ratio test statistics for joint test2.
}
\item{pho}{
Correlation value computed by permutations.
}
}
\description{
This function implements an algorithm for computing various tests of mean
and variance differences, including the DMVC+ test that specifically addresses 
the hypermethylation and hypervariability for cancer-specific CpGs
}

\references{
Dai, J, Wang, X, Chen, H and others. (2021). Incorporating increased 
variability in discovering cancer methylation markers, 
Biostatistics, submitted.
}
\examples{
data(beta)
data(covariate)
out=dmvc(beta=beta,covariate=covariate)

}

