% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_functions.R
\name{performance}
\alias{performance}
\title{Evaluate Regression Model Performance using Various Metrics}
\usage{
performance(y_obs, y_pred, measures = c("NRMSE", "NMAE", "PCC"))
}
\arguments{
\item{y_obs}{Observed response values}

\item{y_pred}{Predicted response values}

\item{measures}{Performance measures. One can specify a single measure or a
vector containing multiple measures in terms of common error or similarity
metrics. The available options are roughly divided into 3 categories -
\itemize{
\item "MSE", "RMSE", "NRMSE" for mean squared error, root mean squared error, and
normalized root mean squared error, respectively.
\item "MAE", "NMAE" for mean absolute error, and normalized mean absolute error,
respectively.
\item "PCC", "SCC", "RSQ" for Pearson's correlation, Spearman's correlation, and
R-squared, respectively.
}

Defaults to \code{c("NRMSE", "NMAE", "PCC")}.}
}
\value{
A vector containing the performance metric values.
}
\description{
This function produces the predictive performance for a regression model
using various common performance metrics such as MSE, R-squared, or
Correlation coefficients.
}
\examples{
set.seed(654321)
x <- rnorm(1000, 0.2, 0.5)
y <- x^2 + rnorm(1000, 0, 0.1)
y_fit <- predict(lm(y ~ x))
print(performance(y, y_fit, measures = c("MSE", "RSQ")))

}
\keyword{model-evaluation}
\keyword{regression-performance}
