% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_modeling.R
\name{EN_predict}
\alias{EN_predict}
\title{Predictive Modeling using Elastic Net}
\usage{
EN_predict(
  x_train,
  y_train,
  x_test,
  lims,
  optimize = FALSE,
  alpha = 0.8,
  seed = NULL,
  verbose = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{x_train}{Training features for designing the EN regressor.}

\item{y_train}{Training response for designing the EN regressor.}

\item{x_test}{Test features for which response values are to be predicted.
If \code{x_test} is not given, the function will return the trained model.}

\item{lims}{Vector providing the range of the response values for modeling.
If missing, these values are estimated from the training response.}

\item{optimize}{Flag for model tuning. If \code{TRUE}, performs a grid search for
parameters. If \code{FALSE}, uses the parameters provided. Defaults to \code{FALSE}.}

\item{alpha}{EN mixing parameter with \eqn{0 \le \alpha \le 1}. \code{alpha = 1}
is the lasso penalty, and \code{alpha = 0} the ridge penalty. Defaults to \code{0.8}.
Valid only when \code{optimize = FALSE}.}

\item{seed}{Seed for random number generator (for reproducible outcomes).
Defaults to \code{NULL}.}

\item{verbose}{Flag for printing the tuning progress when \code{optimize = TRUE}.
Defaults to \code{FALSE}.}

\item{parallel}{Flag for allowing parallel processing when performing grid
search \emph{i.e.}, \code{optimimze = TRUE}. Defaults to \code{FALSE}.}
}
\value{
If \code{x_test} is missing, the trained EN regressor.

If \code{x_test} is provided, the predicted values using the model.
}
\description{
This function trains a Elastic Net regressor using the training data
provided and predict response for the test features. This implementation
depends on the \code{glmnet} package.
}
\note{
The response values are filtered to be bound by range in \code{lims}.
}
\examples{
set.seed(86420)
x <- matrix(rnorm(3000, 0.2, 1.2), ncol = 3);    colnames(x) <- paste0("x", 1:3)
y <- 0.3*x[, 1] + 0.1*x[, 2] - x[, 3] + rnorm(1000, 0, 0.05)

## Get the model only...
model <- EN_predict(x_train = x[1:800, ], y_train = y[1:800], alpha = 0.6)

## Get predictive performance...
y_pred <- EN_predict(x_train = x[1:800, ], y_train = y[1:800], x_test = x[801:1000, ])
y_test <- y[801:1000]
print(performance(y_test, y_pred, measures = "RSQ"))

}
\keyword{elastic-net}
\keyword{penalized-regression}
\keyword{regularization}
