% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcData.R
\name{addDataDF}
\alias{addDataDF}
\title{addDataDF}
\usage{
addDataDF(dat, RT = NULL, Error = NULL)
}
\arguments{
\item{dat}{DataFrame (see createDF)}

\item{RT}{RT parameters (see rtDist)}

\item{Error}{Error parameters (see errDist)}
}
\value{
DataFrame with RT (ms) and Error (bool) columns
}
\description{
Add simulated ex-gaussian reaction-time (RT) data and
binary error (Error = 1, Correct = 0) data to an R DataFrame. This function
can be used to create simulated data sets.
}
\examples{
# Example 1: default dataframe
dat <- createDF()
dat <- addDataDF(dat)
head(dat)
hist(dat$RT, 100)
table(dat$Error)

# Example 2: defined overall RT parameters
dat <- createDF(nSubjects = 50, nTrl = 50, design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat, RT = c(500, 150, 100))
boxplot(dat$RT ~ dat$Comp)
table(dat$Comp, dat$Error)

# Example 3: defined RT + Error parameters across conditions
dat <- createDF(nSubjects = 50, nTrl = 50, design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat,
                 RT = list("Comp_comp"   = c(500, 80, 100),
                           "Comp_incomp" = c(600, 80, 140)),
                 Error = list("Comp_comp"   = 5,
                              "Comp_incomp" = 15))
boxplot(dat$RT ~ dat$Comp)
table(dat$Comp, dat$Error)

# Example 4:
# create dataframe with defined RT + Error parameters across different conditions
dat <- createDF(nSubjects = 50, nTrl = 50, design = list("Comp" = c("comp", "incomp", "neutral")))
dat <- addDataDF(dat,
                 RT = list("Comp_comp"      = c(500, 150, 100),
                           "Comp_neutral"   = c(550, 150, 100),
                           "Comp_incomp"    = c(600, 150, 100)),
                 Error = list("Comp_comp"    =  5,
                              "Comp_neutral" = 10,
                              "Comp_incomp"  = 15))
boxplot(dat$RT ~ dat$Comp)
table(dat$Comp, dat$Error)

# Example 5:
# create dataframe with defined RT + Error parameters across different conditions
dat <- createDF(nSubjects = 50, nTrl = 50,
                design = list("Hand" = c("left", "right"),
                              "Side" = c("left", "right")))
dat <- addDataDF(dat,
                 RT = list("Hand:Side_left:left"   = c(400, 150, 100),
                           "Hand:Side_left:right"  = c(500, 150, 100),
                           "Hand:Side_right:left"  = c(500, 150, 100),
                           "Hand:Side_right:right" = c(400, 150, 100)),
                 Error = list("Hand:Side_left:left"   = c(5,4,2,2,1),
                              "Hand:Side_left:right"  = c(15,4,2,2,1),
                              "Hand:Side_right:left"  = c(15,7,4,2,1),
                              "Hand:Side_right:right" = c(5,8,5,3,1)))

boxplot(dat$RT ~ dat$Hand + dat$Side)
table(dat$Error, dat$Hand, dat$Side)

}
