% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foodData.R
\name{foodData}
\alias{foodData}
\title{Single-function food dataframe creation}
\usage{
foodData(
  filepath = filepath,
  redmeat_ids,
  diets,
  max_scale,
  emission_cols = NULL,
  override_min = NULL
)
}
\arguments{
\item{filepath}{Path in which the dataset, in .xlsx format, is stored..}

\item{redmeat_ids}{Vector of unique food IDs that are redmeat.}

\item{diets}{Chosen diets. Constraint sheets in foods dataset must be of format 'constraints_DIETNAME_diet_foods', then the parameter passed will be DIETNAME. Can be a vector of diets in format c('DIETNAME1','DIETNAME2',...,'DIETNAMEN').}

\item{max_scale}{Maximum scale. Default is two.}

\item{emission_cols}{Optional parameter. Emission column names if standard dataset isn't used.}

\item{override_min}{If is not null, overrides all minimum values}
}
\value{
Foods dataframe.
}
\description{
Creates foods dataframe, with emission, nutrients, constraints and price data, in a single function.
}
