% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_CMP_methods.R
\name{AIC_CMP}
\alias{AIC_CMP}
\alias{AIC.glm_CMP}
\alias{BIC.glm_CMP}
\title{AIC and BIC for COM-Poisson Fitted Models}
\usage{
\method{AIC}{glm_CMP}(object, ..., k = 2)

\method{BIC}{glm_CMP}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"glm_CMP"}, typically the result of a
call to \code{\link{glm.CMP}}.}

\item{...}{optionally more fitted model objects.}

\item{k}{numeric, the \emph{penalty} per parameter to be used; the
    default \code{k = 2} is the classical AIC.}
}
\description{
Computes the Akaike's information criterion or the Schwarz's Bayesian criterion
for COM-Poisson Fits
}
\examples{
## Estimate a COM-Poisson model
Bids$size.sq <- Bids$size ^ 2
fit <- glm.CMP(formula.mu = numbids ~ leglrest + rearest + finrest +
              whtknght + bidprem + insthold + size + size.sq + regulatn,
              formula.nu = numbids ~ 1, data = Bids)

## Compute its AIC and BIC
AIC(fit)
BIC(fit)
}
