% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addItem.R
\name{addItems}
\alias{addItems}
\title{Add multiple data items}
\usage{
addItems(dgeObj, itemList, itemTypes, parents, itemAttr, overwrite = FALSE)
}
\arguments{
\item{dgeObj}{A class DGEobj created by function initDGEobj()}

\item{itemList}{A named list of data items to add to DGEobj}

\item{itemTypes}{A list of type values for each item on itemList}

\item{parents}{(optional) A list of parent values for each item on itemList
(optional, but highly recommended)}

\item{itemAttr}{(optional) An named list of attributes to add to each item.
These attributes will be attached to all items in the call.}

\item{overwrite}{Whether to overwrite a matching data object stored in the
itemName slot (default = FALSE)}
}
\value{
A DGEobj
}
\description{
Add multiple data items
}
\examples{
\dontrun{
   # NOTE: Requires the edgeR package

   # Add normalized counts and log2CPM as additional "assay" items in the DGEobj
   dgeObj  <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))
   dgeList <- edgeR::calcNormFactors(edgeR::DGEList(dgeObj$counts), method="TMM")
   log2cpm <- edgeR::cpm(dgeList, log = TRUE)

   dgeObj <- addItems(dgeObj,
                      itemList = list(newDgelist = dgeList, Log2CPM = log2cpm),
                      itemTypes = list("assay", "assay"),
                      parents = list("counts", "newDgelist")
   )
   inventory(dgeObj)
}

}
