#' Internal function for multiple DEoptim runs
#' @keywords internal
.run_demulti <- function(loglik_fn, x, lower, upper,
                         NP = 100, itermax = 10000, reltol = 5e-6, steptol = 50,
                         F = 0.8, CR = 0.9, strategy = 2, parallelType = 0,
                         packages = c("stats"), parVar = NULL,
                         n_runs = 20, quiet = 2) {

  DE_list <- vector("list", n_runs)
  bestvals <- rep(NA_real_, n_runs)

  pb_tick <- function(i) NULL
  if (quiet == 2) {
    pb_txt <- txtProgressBar(min = 0, max = n_runs, char = '+', style = 3)
    pb_tick <- function(i) setTxtProgressBar(pb_txt, i)
  }

  for (i in seq_len(n_runs)) {
    ctrl <- DEoptim::DEoptim.control(NP = NP, itermax = itermax,
                                     reltol = reltol, steptol = steptol,
                                     F = F, CR = CR, strategy = strategy,
                                     trace = ifelse(quiet == 1, TRUE, FALSE),
                                     parallelType = parallelType,
                                     packages = packages, parVar = parVar)
    res <- DEoptim::DEoptim(fn = function(par) -loglik_fn(par, x),
                            lower = lower, upper = upper,
                            control = ctrl)
    DE_list[[i]] <- res
    bestvals[i] <- res$optim$bestval
    if (quiet == 1) message(sprintf("Run %3d bestval = %g", i, bestvals[i]))
    if (quiet == 2) pb_tick(i)
  }
  if (quiet == 2) close(pb_txt)

  best_run <- which.min(bestvals)
  best_fit <- DE_list[[best_run]]$optim$bestmem
  list(best_run = best_run, bestvals = bestvals, best_fit = best_fit)
}
