% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiAnalysis.R
\name{selective_explanation}
\alias{selective_explanation}
\title{selective_explanation}
\usage{
selective_explanation(
  model,
  alternatives = NULL,
  print = TRUE,
  as_character = FALSE,
  round = NULL,
  id = NULL,
  evaluate = FALSE,
  ...
)
}
\arguments{
\item{model}{A \link{DexiModel} object. Required.}

\item{alternatives}{A \code{data.frame} of alternatives or indices to \code{model$alternatives}.
The default value \code{NULL} selects \code{model$alternatives}.}

\item{print}{\code{logical(1)}. When \code{TRUE}, pretty print (add headings and left justify) the results,
using \code{\link[=print_selective_explanation]{print_selective_explanation()}}.}

\item{as_character}{\code{logical(1)}. Whether to represent alternative values
numerically (\code{FALSE}) or using text (\code{TRUE}).}

\item{round}{An integer number, argument to \code{\link[=value_text]{value_text()}}.}

\item{id}{\code{character(1)}.
Determines the contents of the first or first two columns of the resulting \code{data.frame}s:
\describe{
\item{\code{"id"}}{Attribute IDs.}
\item{\code{"structure"}}{Attribute \verb{$structure() + $name}.}
\item{anything else}{Equivalent to both \code{"id"} and \code{"structure"}.}
}}

\item{evaluate}{\code{logical(1)}. Whether or not to evaluate \code{alternatives} beforehand.}

\item{...}{Optional parameters for \code{\link[=evaluate]{evaluate()}}.}
}
\value{
A list of lists: For each alternative contains a list of two data.frames, corresponding
to \code{"bad"} and \code{"good"} qualities, respectively.
May be pretty-printed using \code{\link[=print_selective_explanation]{print_selective_explanation()}}.
}
\description{
Selective Explanation: Displays subtrees of alternatives' values in which
values are particularly weak (value quality is "bad") and
particularly strong (value quality is "good").
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

# Print selective explanation of two Car$alternatives.
selective_explanation(Car)

alt <- Car$alternative("MyCar",
       BUY.PRICE="low", MAINT.PRICE="*", X.PERS="more", X.DOORS="4", LUGGAGE=2, SAFETY=c(1, 3))
alte <- Car$evaluate(alt)

# Print selective explanation of `alte`.
selective_explanation(Car, alte)

# Print selective explanation of both `alt` and `alte`.
selective_explanation(Car, rbind.data.frame(alt, alte))
}
\seealso{
\code{\link[=value_qualities]{value_qualities()}}, \code{\link[=value_text]{value_text()}}, \code{\link[=print_selective_explanation]{print_selective_explanation()}}, \code{\link[=evaluate]{evaluate()}}
}
