% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiValues.R
\name{export_dexi_value}
\alias{export_dexi_value}
\title{export_dexi_value}
\usage{
export_dexi_value(value)
}
\arguments{
\item{value}{A DEXi value: \code{NA}, \code{NULL}, a single number, integer vector (a set) or a distribution.}
}
\value{
A string representation of \code{value}.
}
\description{
Convert a DEXi \code{value} to a character string that is understood by DEXi/DEXiWin software
while importing data about alternatives.
}
\examples{
export_dexi_value(NULL)                            # "<undefined>"
export_dexi_value(NA)                              # "<undefined>"
export_dexi_value(1)                               # "1"
export_dexi_value(3.2)                             # "3.2"
export_dexi_value(c(1, 3, 5))                      # "1;3;5"
export_dexi_value(distribution(0.1, 0.9))          # "1/0.1;2/0.9"
export_dexi_value(distribution(0, 0.1, 0, 0.9, 0)) # "2/0.1;4/0.9"

}
