% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiEvaluate.R
\name{attribute_effect}
\alias{attribute_effect}
\title{attribute_effect}
\usage{
attribute_effect(model, attribute, alternative, target = NULL, seq = NULL, ...)
}
\arguments{
\item{model}{A \link{DexiModel} object. Required.}

\item{attribute}{A \link{DexiAttribute} with assigned discrete or continuous scale.}

\item{alternative}{A \code{data.frame} containing a single alternative.}

\item{target}{Target \link{DexiAttribute}. Defaults to \code{model$first()}.}

\item{seq}{A sequence of \code{attribute}'s numeric values for which to evaluate \code{alternative}.
For discrete scales: Must be a sequence of integers. Defaults to \code{attribute$scale$full_range()}.
For continuous scales: \code{seq} is required.}

\item{...}{Optional parameters passed to \code{\link[=evaluate_attribute]{evaluate_attribute()}}.}
}
\value{
A list of \code{target} evaluation results, indexed by the values of \code{seq}.
}
\description{
Given a single \code{alternative}, determine the effects of varying \code{attribute} on \code{target} attribute.
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

alt <- Car$alternative("MyCar",
         BUY.PRICE="low", MAINT.PRICE=2, X.PERS="more", X.DOORS="4", LUGGAGE=2, SAFETY="medium")
# Determine the effect of changing "SAFETY" balues on "CAR.1"
attribute_effect(Car, "SAFETY", alt)
# Returns a list of "CAR.1" values corresponding to consecutive values of "SAFETY"
attribute_effect(Car, "LUGGAGE", alt, "TECH.CHAR.")
# Returns a list of "TECH.CHAR." values corresponding to consecutive values of "LUGGAGE"
}
\seealso{
\code{\link[=evaluate_attribute]{evaluate_attribute()}}
}
