% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiFunctions.R
\docType{class}
\name{DexiTabularFunction-class}
\alias{DexiTabularFunction-class}
\alias{DexiTabularFunction}
\title{DexiTabularFunction}
\description{
\code{DexiTabularFunction} is a RC class, derived from \link{DexiFunction}.
Functions of this type aggregate attribute values according to \emph{decision rules},
defined in terms of a \emph{decision table}.
}
\details{
A decision table contains as many decision rules as there are possible combinations of
input attributes' values. For instance, if some \code{attribute} has two inputs whose
discrete scales have three and four values, respectively (i.e., \code{attribute$dim() == c(3,4)}),
then the number of rules is equal to \code{prod(attribute$dim()) == 12}. Each rule defines the
value of \code{attribute} for one of the possible combinations of values of \code{attribute$inputs}.
Thus, a decision table can be interpreted as a lookup table that, given a vector
of values of \code{attribute$inputs} (i.e., function arguments) returns the corresponding
\code{attribute} value.

Objects of class \code{DexiTabularFunction} store decision rules in \code{values}, a multi-dimensional
list that contains rule values. In most cases, a rule value is a single integer,
representing an ordinal number of some value from \code{attribute$scale}. In a general case, however,
a rule value can be an integer vector, representing a (sub)set of values from \code{attribute$scale}.
}
\section{Fields}{

\describe{
\item{\code{attribute}}{\link{DexiAttribute}. The attribute this function is associated with.
Both the attribute and its inputs are required to be discrete (i.e., associated with
\code{DexiDiscreteScale}s).}

\item{\code{values}}{A multi-dimensional list of rule values. The dimensions of the list are equal to
\code{attribute$dim()}, and the length of the list is \code{nvals() == prod(dim)}. The list
contains rule values that are in general value sets, i.e., integer vectors of value indices
w.r.t. \code{attribute$scale}.}

\item{\code{args}}{A list of integer vectors, containing all possible combinations of values of \code{attribute$inputs}.
\code{args} and \code{values} are of the same length and ordered so that, for each \code{i}, \code{args[[i]]}
defines function arguments that map to \code{values[[i]]}).}
}}

\section{Methods}{

\describe{
\item{\code{evaluate(x)}}{A silent wrapper around \code{value(x)}; it returns \code{NULL} when
\code{value(x)} fails with an error.}

\item{\code{nargs()}}{Return the number of function arguments.}

\item{\code{nvals()}}{Return the function size (number of rules).}

\item{\code{to_string()}}{Return a short informative string about the size and dimensions of \code{values}.}

\item{\code{value(x)}}{Return the function value for arguments \code{x}, where arguments are
a numeric vector of length equal to \code{att$inputs}.
Additionally, arguments of a \code{DexiTabularFunctions$value()} must be integer numbers,
and the argument of \code{DexiDiscretizeFunctions$value()} must be a single number.}

\item{\code{verify()}}{Check the correctnes of this function object and its fields.
Result: \code{error()} or \code{TRUE}.}
}}

\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

# For example, consider the function of attribute CAR
fnc <- Car$attrib("CAR")$funct

# Print fields and basic properties of fnc
fnc$verify()
att_names(fnc$attribute)
fnc$values
fnc$args
fnc$nargs()
fnc$nvals()
fnc$to_string()

# Try some args to value mappings
fnc$evaluate(c(1, 1))
fnc$evaluate(c(2, 2))
fnc$evaluate(c(3, 4))
fnc$evaluate(c(4, 4)) # the first argument is out of bounds, returns NULL

}
\seealso{
\code{\link[=dexi_index]{dexi_index()}}, \code{\link[=dexi_table]{dexi_table()}}, \code{\link[=make_args]{make_args()}}
}
