print.DDPstar <-
function(x, ...) {
	
	cat("\nCall:\n", paste(deparse(x$call), sep = "\n", collapse = "\n"), "\n", sep = "")
	cat(paste0("\n Dependent Dirichet Processes with P-splines"))
	cat("\n----------------------------------------------\n")

	waic <- !is.null(x$WAIC)
	lpml <- !is.null(x$lpml)
	dic <- !is.null(x$DIC)

	if(waic | lpml) {
		cat("\n\nModel selection criteria")
		cat("\n----------------------------------------------\n")
		if(waic) {
			cat(paste("Widely applicable information criterion (WAIC): ", round(x$WAIC$WAIC, 3),"\n"))		
		}

		if(lpml) {
			cat(paste("Pseudo marginal likelihood (LPML): ", round(x$lpml$lpml),"\n"))		
		}

		if(dic) {
			cat(paste("Deviance information criterion (DIC): ", round(x$DIC$DIC),"\n"))		
		}
	}
	invisible(x)   
}
