get_vars_formula <-
function(formula) {
	env <- environment(formula) 
	if(inherits(formula, "character"))		  
		formula <- as.formula(formula)

	tf <- terms.formula(formula, specials = c("f", "ns", "bs", "rae"))
    if(!is.null(attr(tf,"specials")$ns) | !is.null(attr(tf,"specials")$bs)) {
        stop("'ns' (natural splines) or 'bs' (B-splines) are not allowed in the formula. Please use 'f' instead.")
    }

	if (attr(tf, "response") > 0) {
		response <- as.character(attr(tf, "variables")[2])
	} else {
		stop("The formula should include the response variable (left hand side)")
	}

	# Number of tems
	terms <- attr(tf, "term.labels")
	nt <- length(terms)

	# Smooth terms
	ns <- sort(attr(tf,"specials")$f) - 1 # Response is in the formula
	# Random terms
	nre <- sort(attr(tf,"specials")$rae) - 1 # Response is in the formula

	vars.formula <- NULL
	if(nt) {
		for (i in 1:nt) {
			if (i %in% ns) { # Smooth components        
                vars.formula <- c(vars.formula, eval(parse(text = terms[i]))$vars)
            } else if(i %in% nre) { # Random components
            	vars.formula <- c(vars.formula, eval(parse(text = terms[i]))$vars)
        	} else { # Parametric components				
				vars.formula <- c(vars.formula, all.vars(formula(paste("~", terms[i]))))
			}
        }        
    }
    vars.formula <- unique(vars.formula)
    vars.formula
}
