bbase.interaction.factor.by.curve.bs <-
function(x, factor, ndx, bdeg = 3, pord = 2, eps = 1e-5) {
	factor <- droplevels(factor)
	factor.levels <- levels(factor)
	
	# Ordering in the data set
	ord <- NULL
	for(i in 1:length(factor.levels)) {
		ord <- c(ord, which(factor == factor.levels[i]))
	}
	# Smooth part
	terms <- list()
	interaction.smooth.part <- list()
	interaction.penalty.part <- list()

	for(i in 1:length(factor.levels)) {
		MM <- bbase.bs(x = x[factor == factor.levels[i]], ndx = ndx, bdeg = bdeg, pord = pord, intercept = FALSE)
		terms[[i]] <- MM
		interaction.smooth.part[[i]] <- MM$B
		interaction.penalty.part[[i]] <- MM$K

	}
	names(terms) <- factor.levels
	aux <- as.matrix(bdiag(interaction.smooth.part))
	B <- aux[order(ord),]
	res <- list()
	res$B <- B
	res$K <- interaction.penalty.part
	res$terms <- terms
	res
}
