\name{besagnewell.boot}

\alias{besagnewell.boot}
\alias{besagnewell.pboot}

\title{Generate Boostrap Replicates of Besag and Newell's Statistic}

\description{
Generate boostrap replicates of Besag and Newell's statistic, by means of
function \emph{boot} from \emph{boot} library.  Notice that these functions
should not  be used separately but as argument \emph{statistic} when calling
function \emph{boot}.


\emph{besagnewell.boot} is used when performing a non-parametric bootstrap.


When sampling models are \emph{Multinomial} or \emph{Poisson} it is quite
straightforwad to obtain the actual p-value as shown in the examples. When
\emph{Permutation} or \emph{Negative Binomial} are used, simulation must be
used to estimate significance.  }


\usage{
besagnewell.boot(data, i, ...)
besagnewell.pboot(...)
}


\arguments{
\item{data}{A dataframe with the data, as explained in \emph{DCluster}.}
\item{i}{Permutation generated by the non-parametric bootstrap.}
\item{...}{Additional arguments needed.}
}


\value{
Both functions return the value of the statistic.
}

\seealso{
DCluster, boot, besagnewell, besagnewell.stat, bn.iscluster
}

\references{
Besag, J. and Newell, J.(1991). The detection of clusters in rare diseases. 
Journal of the Royal Statistical Society A  154, 143-155.
}

\examples{
library(boot)
library(spdep)

data(nc.sids)

sids<-data.frame(Observed=nc.sids$SID74)
sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74))
sids<-cbind(sids, x=nc.sids$x, y=nc.sids$y)

niter<-100

#Permutation  model
besn.perboot<-boot(sids, statistic=besagnewell.boot, R=niter, k=20)
plot(besn.perboot)#Display results
}

\keyword{spatial}
