% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gauss.sim.R
\name{gauss.sim}
\alias{gauss.sim}
\title{Simulates time-series data from the Gauss map}
\usage{
gauss.sim(
  alpha = 6.2,
  beta = -0.5,
  s = 0,
  x0 = runif(1, 0, 1),
  n = 1000,
  n.start = 50
)
}
\arguments{
\item{alpha}{a non-negative integer denoting the value of parameter \code{alpha} (Default 6.2).}

\item{beta}{a non-negative integer denoting the value of parameter \code{beta} (Default -0.5).}

\item{s}{a non-negative integer denoting the variance value of the error term. If \eqn{s=0} gives the standard deterministic map (Default 0).}

\item{x0}{a non-negative integer denoting the initial condition (Default random number between 0 and 1).}

\item{n}{a non-negative integer denoting the length (Default 1000).}

\item{n.start}{a non-negative integer denoting the number of observations that will be discarded to ensure that the values are in the attractor (Default 50).}
}
\value{
A time-series data object generated from the Gauss map with or without an additive measurement noise term. This dataset could be useful for researchers interested in the field of chaotic dynamic systems and non-linear time series analysis and professors (and students) who teach (learn) courses related to those topics.
}
\description{
This function simulates time-series data from the Gauss map considering the parameter set selected by the user. The initial condition is a random number between 0 and 1. Some initial conditions may lead to an unstable system that will tend to infinity.
}
\note{
This function provides also noisy time-series data from the deterministic gauss map adding an additive measurement noise term if \eqn{s>0}. We have added to each time-series data a normal multinomial error term denoted by \eqn{{\varepsilon _t} \sim N\left( {0,s} \right)} with different variance values (\eqn{s}). In this sense we have considered it appropriate to add a measurement noise term because most real-world observed time-series data are usually noise-contaminated signals, characterised by an erratic and persistent volatility in certain periods and there is almost always a source of noise linked to measurement errors in real-world datasets.
}
\examples{
## set.seed(34)
## Simulates time-series data from the deterministic gauss map
## with a chaotic behaviour.
## ts <- gauss.sim(alpha=6.2, beta=-0.5, s=0, n=1000)
##
## Simulates time-series data from the deterministic gauss map
## with a non-chaotic behaviour.
## ts <- gauss.sim(alpha=4.9, beta=-0.58, s=0, n=1000)
}
\references{
Hilborn, R.C. 2004 Chaos and nonlinear dynamics: an introduction for scientists and engineers. Oxford, Univ. Press, New York.
}
\author{
Julio E. Sandubete, Lorenzo Escot
}
