% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StandICModelSelect.R
\name{StandICModelSelect}
\alias{StandICModelSelect}
\alias{print.StandICModelSelect}
\alias{plot.StandICModelSelect}
\title{Model selection using standardized information criteria}
\usage{
StandICModelSelect(
  x,
  IC = "AIC",
  ref_model_index = NULL,
  sd_cutoff = 2,
  user_df = NULL,
  ...
)

\method{print}{StandICModelSelect}(x, ...)

\method{plot}{StandICModelSelect}(x, ...)
}
\arguments{
\item{x}{A list containing the fitted model objects on which to perform model selection. Model objects must have a \code{logLik} method defined for them.}

\item{IC}{A character string containing the base information criteria to use. Options are "AIC", "BIC", and "AICc" for linear models. Default option is `AIC`.}

\item{ref_model_index}{An integer with the index of the largest candidate model to use as the reference. If not supplied, defaults to the model with largest number of estimated coefficients in \code{x}.}

\item{sd_cutoff}{A numeric describing how many standard deviations to use when formulating a cutoff for model viability.}

\item{user_df}{An optional vector the same length as \code{x} where one can specify the degrees of freedom of each fitted model. If not supplied, the degrees of freedom for each model is calculated to be the number of estimated regression coefficients.}

\item{...}{Additional arguments.}
}
\value{
A list containing the final model selected in addition to standardized information criteria and difference in degrees of freedom for all candidate models.
}
\description{
Perform model selection on a list of models using standardized information criteria.
}
\examples{
# example code
# generate some data
s <- rnorm(200)
t <- rnorm(200)
y <- s + rnorm(200)
# formulate and fit models
model_list <- list(lm(y~1), lm(y~s), lm(y~t), lm(y~s+t))
# perform model selection
model_select <- StandICModelSelect(model_list, IC = "AIC")
# display best model
model_select$best_model
}
