% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMOCLES_bootstrap.R
\name{DAMOCLES_bootstrap}
\alias{DAMOCLES_bootstrap}
\title{Phylogenetic community structure hypothesis test}
\usage{
DAMOCLES_bootstrap(
  phy = ape::rcoal(10),
  pa = matrix(c(phy$tip.label, sample(c(0, 1), ape::Ntip(phy), replace = T)), nrow =
    ape::Ntip(phy), ncol = 2),
  initparsopt = c(0.1, 0.1),
  idparsopt = 1:length(initparsopt),
  parsfix = NULL,
  idparsfix = NULL,
  pars2 = c(0.001, 1e-04, 1e-05, 1000),
  pchoice = 0,
  runs = 999,
  estimate_pars = FALSE,
  conf.int = 0.95
)
}
\arguments{
\item{phy}{phylogeny in phylo format}

\item{pa}{presence-absence table.\cr The first column contains the labels of
the species (corresponding to the tip labels in the phylogeny.\cr The second
column contains the presence (1) or absence (0) of species in the local
community.}

\item{initparsopt}{The initial values of the parameters that must be
optimized}

\item{idparsopt}{The ids of the parameters that must be optimized, e.g. 1:2
for extinction rate, and offset of immigration rate The ids are defined as
follows: \cr id == 1 corresponds to mu (extinction rate) \cr id == 2
corresponds to gamma_0 (offset of immigration rate) \cr}

\item{parsfix}{The values of the parameters that should not be optimized.
See idparsfix.}

\item{idparsfix}{The ids of the parameters that should not be optimized, e.g. c(1) if mu
should not be optimized, but only gamma_0. In that case idparsopt must be
c(2). The default is to fix the parameters not specified in idparsopt.}

\item{pars2}{Vector of settings: \cr \code{pars2[1]} sets the relative
tolerance in the parameters \cr \cr \code{pars2[2]} sets the relative
tolerance in the function \cr \cr \code{pars2[3]} sets the absolute
tolerance in the parameters \cr \cr \code{pars2[4]} sets the maximum number
of iterations}

\item{pchoice}{sets which p-value to optimize and with which root state to
simulate (default pchoice = 0) \cr pchoice == 0 correspond to optimizing sum
of p_0f + p_1f, and simulating with an equal number of root states being 0
or 1 \cr pchoice == 1 correspond to optimizing p_0f, and simulating with
root state being 0\cr pchoice == 2 correspond to optimizing p_1f, and
simulating with root state being 1}

\item{runs}{the number null communities to generate.}

\item{estimate_pars}{Whether to estimate parameters on the simulated
datasets (default = FALSE).}

\item{conf.int}{The width of the conifdence intervals calculated on
bootstrapped parameter estimates}
}
\value{
\item{summary_table}{ \code{mu} gives the maximum likelihood
estimate of mu and confidence intervals in brackets if estimate_pars = TRUE
\code{gamma_0} gives the maximum likelihood estimate of gamma_0 and
confidence intervals in brackets if bootstrap=TRUE \code{loglik} gives the
maximum loglikelihood \code{df} gives the number of estimated parameters,
i.e. degrees of feedom \code{conv} gives a message on convergence of
optimization; conv = 0 means convergence \code{n.obs} gives the number of
species locally present in the observed community \code{mntd.obs} gives the
MNTD of the observed community \code{mpd.obs} gives the MPD of the observed
community \code{runs} gives the number of null communities simulated
\code{mntd.mean.RD} mean of MNTD from null communities generated by a
"Random Draw" model \code{mntd.sd.RD} standard deviation of MNTD from null
communities generated by a "Random Draw" model \code{mntd.obs.z.RD}
standardized effect size of MNTD compared to null communities generated by a
"Random Draw" model (= -1*(mntd.obs - mntd.mean.RD)/ mntd.sd.RD)
\code{mntd.obs.rank.RD} rank of observed MNTD compared to null communities
generated by a "Random Draw" model \code{mntd.obs.q.RD} quantile of observed
MNTD vs. null communities (= mntd.obs.rank.RD /runs + 1) \code{mpd.mean.RD}
mean of MPD from null communities generated by a "Random Draw" model
\code{mpd.sd.RD} standard deviation of MPD from null communities generated
by a "Random Draw" model \code{mpd.obs.z.RD} standardized effect size of MPD
compared to null communities generated by a "Random Draw" model (=
-1*(mpd.obs - mpd.mean.RD)/ mpd.sd.RD) \code{mpd.obs.rank.RD} rank of
observed MPD compared to null communities generated by a "Random Draw" model
\code{mpd.obs.q.RD} quantile of observed MPD vs. null communities (=
mpd.obs.rank.RD /runs + 1) \code{n.mean.DAMOCLES} mean number of species
locally present in the null communities generated by DAMOCLES
\code{mntd.mean.DAMOCLES} mean of MNTD from null communities generated by
DAMOCLES \code{mntd.sd.DAMOCLES} standard deviation of MNTD from null
communities generated by DAMOCLES \code{mntd.obs.z.DAMOCLES} standardized
effect size of MNTD compared to null communities generated by DAMOCLES (=
-1*(mntd.obs - mntd.mean.DAMOCLES)/ mntd.sd.DAMOCLES)
\code{mntd.obs.rank.DAMOCLES} rank of observed MNTD compared to null
communities generated by DAMOCLES \code{mntd.obs.q.DAMOCLES} quantile of
observed MNTD vs. null communities (= mntd.obs.rank.DAMOCLES /runs + 1)
\code{mpd.mean.DAMOCLES} mean of MPD from null communities generated by
DAMOCLES \code{mpd.sd.DAMOCLES} standard deviation of MPD from null
communities generated by DAMOCLES \code{mpd.obs.z.DAMOCLES} standardized
effect size of MPD compared to null communities generated by DAMOCLES (=
-1*(mpd.obs - mpd.mean.DAMOCLES)/ mpd.sd.DAMOCLES)
\code{mpd.obs.rank.DAMOCLES} rank of observed MPD compared to null
communities generated by DAMOCLES \code{mpd.obs.q.DAMOCLES} quantile of
observed MPD vs. null communities (= mpd.obs.rank.DAMOCLES /runs + 1)
\code{loglik.mean.DAMOCLES} mean of loglikelihoods from null communities
generated by DAMOCLES \code{loglik.sd.DAMOCLES} standard deviation of
loglikelihoods from null communities generated by DAMOCLES
\code{loglik.obs.z.DAMOCLES} standardized effect size of loglikelihood
compared to null communities generated by DAMOCLES (= -1*(loglik.obs -
loglik.mean.DAMOCLES)/ loglik.sd.DAMOCLES) \code{loglik.obs.rank.DAMOCLES}
rank of observed loglikelihood compared to null communities generated by
DAMOCLES \code{loglik.obs.q.DAMOCLES} quantile of observed loglikelihoods
vs. null communities (= loglik.obs.rank.DAMOCLES /runs + 1) }
\item{null_community_data}{ \code{run} gives the simulation run
\code{root.state.print} gives the state of the ancestral species in the
local community assumed in the simulation, i.e. present (1) or absent (0)
\code{n} gives the number of species locally present in the observed
community \code{n.RD} gives the number of species locally present in the
null community generated by a "Random Draw" model \code{mntd.RD} gives the
MNTD of the null community generated by a "Random Draw" model \code{mpd.RD}
gives the MPD of the null community generated by a "Random Draw" model
\code{n.DAMOCLES} gives the number of species locally present in the null
community generated by DAMOCLES \code{mntd.DAMOCLES} gives the MNTD of the
null community generated by DAMOCLES \code{mpd.DAMOCLES} gives the MPD of
the null community generated by DAMOCLES \code{loglik.DAMOCLES} gives the
maximum loglikelihood for the null community generated by DAMOCLES
\code{mu.DAMOCLES} gives the maximum likelihood estimate of mu for the null
community generated by DAMOCLES \code{gamma_0.DAMOCLES} gives the maximum
likelihood estimate of gamma_0 for the null community generated by DAMOCLES
}
}
\description{
This function computes the maximum likelihood estimates of colonisation and
local extinction rate for a given phylogeny and presence-absence data under
the DAMOCLES model.  These rate estimates are used to simulate null
communities under the DAMOCLES model.  Standardized effect size of mean
nearest taxon distance (mntd), mean phylogentic distance (mpd) and
loglikelihood are calculated For comparison, standardised effect sizes are
also calculated relative to a "Random-Draw" null model i.e. presence absence
randomised across tips
}
\details{
The output is a list of two dataframes. The first dataframe, summary_table,
contains the summary results. The second dataframe, null_community_data,
contains decsriptive statistics for each null community.
}
\references{
Pigot, A.L. & R.S. Etienne (2015). A new dynamic null model for
phylogenetic community structure. Ecology Letters 18: 153-163.
}
\seealso{
\code{\link{DAMOCLES_ML}} \code{\link{DAMOCLES_sim}}
}
\author{
Rampal S. Etienne
}
\keyword{models}
