% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.densLPS.R
\name{print.densLPS}
\alias{print.densLPS}
\title{Print a summary of the information in a \code{densLPS.object}}
\usage{
\method{print}{densLPS}(x,...)
}
\arguments{
\item{x}{a \code{\link{densLPS.object}}.}

\item{...}{Optional additional print parameters.}
}
\value{
No returned value (just printed summary).
}
\description{
Print summary information on the density estimate obtained by \code{densityLPS} from censored data with given mean and variance.
}
\examples{
require(DALSM)
data(DALSM_IncomeData)
resp = DALSM_IncomeData[,1:2]
fit = DALSM(y=resp,
            formula1 = ~twoincomes+s(age)+s(eduyrs),
            formula2 = ~twoincomes+s(age)+s(eduyrs),
            data = DALSM_IncomeData)
plot(fit$derr)  ## Plot the estimated error density
print(fit$derr) ## ... and provide some descriptive elements on it

}
\references{
Lambert, P. (2021). Fast Bayesian inference using Laplace approximations
in nonparametric double additive location-scale models with right- and
interval-censored data.
\emph{Computational Statistics and Data Analysis}, 161: 107250.
<doi:10.1016/j.csda.2021.107250>
}
\seealso{
\code{\link{densLPS.object}}, \code{\link{plot.densLPS}}, \code{\link{densityLPS}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
