% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.DALSM.R
\name{predict.DALSM}
\alias{predict.DALSM}
\title{Prediction based on a DALSM model}
\usage{
\method{predict}{DALSM}(object, newdata, probs, ...)
}
\arguments{
\item{object}{a \code{\link{DALSM.object}}.}

\item{newdata}{an optional data frame in which to look for variables with which to predict. If omitted, the covariate values in the original data frame used to fit the DALSM model are considered.}

\item{probs}{probability levels of the requested conditional quantiles.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Returns a list containing:
\itemize{
\item{\code{mu} : \verb{ }}{estimated conditional mean.}
\item{\code{sd} : \verb{ }}{estimated conditional standard deviation.}
\item{\code{quant} : \verb{ }}{estimated quantiles (at probability level \code{probs}) of the fitted conditional response in the DALSM model.}
\item{\code{qerr} : \verb{ }}{quantiles (at probability level \code{probs}) of the fitted error distribution in the DALSM model.}
\item{\code{probs} : \verb{ }}{a reminder of the requested probability levels for the fitted quantiles.}
}
}
\description{
Estimated conditional mean and standard deviation of the response based on a DALSM object
 for given covariate values in a data frame 'newdata'. Conditional quantiles can also
 be computed.
}
\examples{
require(DALSM)
data(DALSM_IncomeData)
resp = DALSM_IncomeData[,1:2]
fit = DALSM(y=resp,
            formula1 = ~twoincomes+s(age)+s(eduyrs),
            formula2 = ~twoincomes+s(age)+s(eduyrs),
            data = DALSM_IncomeData)
data2 = data.frame(age=c(40,60),eduyrs=c(18,12))
predict(fit, data = DALSM_IncomeData, newdata=data2, probs=c(.2,.5,.8))
}
\references{
Lambert, P. (2021). Fast Bayesian inference using Laplace approximations
in nonparametric double additive location-scale models with right- and
interval-censored data.
\emph{Computational Statistics and Data Analysis}, 161: 107250.
<doi:10.1016/j.csda.2021.107250>
}
\seealso{
\code{\link{DALSM.object}}, \code{\link{print.DALSM}}, \code{\link{plot.DALSM}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
