% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DimensionalityReduction-class.R
\docType{class}
\name{DimensionalityReduction-class}
\alias{DimensionalityReduction-class}
\title{S4 DimensionalityReduction Class}
\value{
A Dimensionality Reduction advanced analysis object
}
\description{
A Dimensionality Reduction object that holds pertinent Dimensionality Reduction advanced analysis run information.
This class should never be called explicitly. If a user would like to create a new Cytobank Dimensionality Reduction object, utilize the \link{dimensionality_reduction.new} function, or any other \link[=dimensionality_reduction]{Dimensionality Reduction endpoints that return Dimensionality Reduction objects documented in the 'Details' section}.
}
\section{Slots}{

\describe{
\item{\code{analysis_id}}{numeric representing the Dimensionality Reduction analysis ID}

\item{\code{type}}{character representing the Dimensionality Reduction type (tSNE-CUDA, opt-SNE, UMAP, or viSNE)}

\item{\code{name}}{character the name of the Dimensionality Reduction analysis}

\item{\code{status}}{character representing the status of the Dimensionality Reduction analysis}

\item{\code{source_experiment}}{numeric the source experiment ID the Dimensionality Reduction analysis is associated with}

\item{\code{created_experiment}}{numeric representing the experiment that gets created from the Dimensionality Reduction analysis}

\item{\code{.available_channels}}{the list of available channels based off the \link{panels.list} function}

\item{\code{.available_files}}{the list of available files based off the \link{fcs_files.list} function}

\item{\code{.available_populations}}{the list of available populations based off the \link{populations.list} function}
}}

