% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdf5Access.R
\name{readH5ADObsVar}
\alias{readH5ADObsVar}
\title{Extract a variable from adata.obs stored in an H5AD file}
\usage{
readH5ADObsVar(filename, obsKey, named = TRUE, categoricalAsFactor = TRUE)
}
\arguments{
\item{filename}{File path to the H5AD file.}

\item{obsKey}{The variable name to extract, must use only one character
string.}

\item{named}{Logical, whether to name the vector with cell IDs that came from
\code{adata.obs_names}. Default \code{TRUE}.}

\item{categoricalAsFactor}{Logical, whether to convert categorical variables
to factors. Default \code{TRUE}.}
}
\value{
A vector of the extracted variable, or a factor if the variable is
encoded to be categorical and \code{categoricalAsFactor = TRUE}.
}
\description{
Primarily designed for fetching the annotation used for visualization.
}
\examples{
\dontrun{
h5adFile <- "path/to/analysis.h5ad"
cluster <- readH5ADObsVar(h5adFile, "leiden")
}
}
\seealso{
Other H5AD-reader: 
\code{\link{readH5ADObsNames}()},
\code{\link{readH5ADUnsSpMat}()},
\code{\link{readVelocytoLoom}()}
}
\concept{H5AD-reader}
